# 画面設計書 20-WASMFS Scratchpad

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるWASMFS Scratchpad画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、WASMFS（WebAssembly File System）とOPFS（Origin Private File System）の統合を実験・テストするためのスクラッチパッド（実験用）ページである。

**業務上の目的・背景**：SQLite WASMビルドにおいて、WASMFSとOPFSの統合は永続ストレージ機能の実現に重要である。本画面は、開発者がこの統合の動作を検証・実験するための場を提供する。メインスレッドでWASMFS/OPFS対応のsqlite3モジュールを使用し、永続データベースの作成・読み取り・更新をテストできる。出力はすべて開発者コンソールに表示される。

**画面へのアクセス方法**：インデックスページ（index.html）の「WASMFS」リンクからアクセスするか、直接 `scratchpad-wasmfs.html` にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時にWorker（scratchpad-wasmfs.mjs）を起動
2. Workerがsqlite3-wasmfs.mjsをインポートしてモジュール初期化
3. WASMFS/OPFS永続ディレクトリを確認
4. 永続データベースを作成し、テーブル作成・データ挿入・クエリ実行
5. 結果を開発者コンソールに出力

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）

**権限による表示制御**：特になし（開発者向け実験ページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | WASMFS実験用モジュール初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | WASMFS/OPFS統合の実験 |

## 画面種別

実験画面（結果は開発者コンソールに出力）

## URL/ルーティング

```
/ext/wasm/scratchpad-wasmfs.html
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| （なし） | - | - | - | 入力項目なし |
| コンソール出力 | 出力 | text | - | テスト実行ログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトルバー | "sqlite3 WASMFS/OPFS Main-thread Scratchpad" | 常時表示 |
| 説明文 | WASMFS/OPFS統合実験の説明 | 常時表示 |
| WASMFS必須の注意 | WASMFSサポート付きビルドが必要である旨 | 常時表示 |
| コンソール案内 | 結果は開発者コンソールで確認する旨 | 常時表示 |
| テスト出力エリア | 空（結果はコンソール） | 常時 |

## イベント仕様

### 1-ページ読み込み

1. Worker（scratchpad-wasmfs.mjs）をES6モジュールとして起動
2. Worker内でsqlite3-wasmfs.mjsをインポート
3. sqlite3InitModule()でモジュール初期化
4. runTests(sqlite3)でテスト実行

### 2-Worker内テスト実行（runTests）

1. sqlite3_wasmfs_opfs_dir()で永続ディレクトリを取得
2. 永続ディレクトリがあればDB作成、なければ警告出力
3. new oo.DB(persistentDir+'/foo.db')でDB作成
4. test1(db, sqlite3)でテーブル作成・データ挿入・クエリ実行
5. 完了後にdb.close()

### 3-テスト関数（test1）

1. CREATE TABLE IF NOT EXISTS t(a)でテーブル作成
2. トランザクション内でINSERT（現在時刻を挿入）
3. SELECT COUNT(*)でデータ件数を出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| test1実行 | t | CREATE/INSERT/SELECT | テストデータ操作 |

### テーブル別更新項目詳細

#### t テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE | - | CREATE TABLE IF NOT EXISTS t(a) | テーブル作成 |
| INSERT | a | new Date().getTime() | 現在のタイムスタンプ |
| SELECT | - | count(*) | データ件数取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Loaded module: {sqlite3}" | モジュールロード完了時 |
| MSG002 | 情報 | "Loaded sqlite3: {version} {sourceid}" | sqlite3バージョン表示 |
| MSG003 | 情報 | "Persistent storage dir: {dir}" | 永続ディレクトリ利用可能時 |
| MSG004 | エラー | "No persistent storage available." | 永続ストレージ非対応時 |
| MSG005 | 情報 | "DB filename: {filename}" | DB作成成功時 |
| MSG006 | 情報 | "Running test1()..." | テスト関数実行時 |
| MSG007 | 情報 | "Number of values in table t: {count}" | SELECT COUNT結果 |
| MSG008 | 情報 | "Total test time: {ms}ms" | テスト完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| WASMFS非対応ビルド | sqlite3_wasmfs_opfs_dir()がnull/空を返し、警告出力 |
| DB操作エラー | コンソールにエラー出力（try-catch内） |

## 備考

- WASMFSサポート付きでビルドされたsqlite3モジュールが必要
- 永続ストレージ（OPFS）が利用可能な場合、DBはリロード後も保持される
- すべての出力は開発者コンソールで確認する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

sqlite3オブジェクトとOPFSディレクトリ構造。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scratchpad-wasmfs.mjs | `ext/wasm/scratchpad-wasmfs.mjs` | capi, oo, wasmオブジェクトの使用 |

**読解のコツ**: sqlite3.capi（C API）、sqlite3.oo1（オブジェクト指向API）、sqlite3.wasm（WASMユーティリティ）の3つの主要名前空間を使用。

#### Step 2: エントリーポイントを理解する

HTMLファイルでのWorker起動。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scratchpad-wasmfs.html | `ext/wasm/scratchpad-wasmfs.html` | Worker生成（ES6モジュール） |

**主要処理フロー**:
- **行22-27**: Worker生成（type: 'module'）

#### Step 3: テスト処理を理解する

Worker内でのWASMFS/OPFSテストロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scratchpad-wasmfs.mjs | `ext/wasm/scratchpad-wasmfs.mjs` | runTests関数とtest1関数 |

**主要処理フロー**:
- **行16**: sqlite3-wasmfs.mjsをインポート
- **行26-35**: test1関数（テーブル作成・データ挿入）
- **行37-68**: runTests関数
- **行42-43**: バージョン情報出力
- **行44**: sqlite3_wasmfs_opfs_dir()で永続ディレクトリ取得
- **行52**: new oo.DB(persistentDir+'/foo.db')でDB作成
- **行56-63**: test1実行とクローズ

### プログラム呼び出し階層図

```
scratchpad-wasmfs.html
    │
    └─ new Worker('scratchpad-wasmfs.mjs', {type:'module'})
           │
           ├─ import sqlite3InitModule from './jswasm/sqlite3-wasmfs.mjs'
           │
           └─ sqlite3InitModule().then(runTests)
                  │
                  ├─ capi.sqlite3_libversion() ... バージョン表示
                  ├─ capi.sqlite3_wasmfs_opfs_dir() ... 永続ディレクトリ取得
                  │
                  ├─ new oo.DB(persistentDir+'/foo.db')
                  │
                  └─ test1(db, sqlite3)
                         ├─ db.exec("CREATE TABLE IF NOT EXISTS t(a)")
                         ├─ db.transaction() → db.prepare() → bind() → stepFinalize()
                         └─ db.selectValue("SELECT COUNT(*) FROM t")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし) ─────────────▶ Worker (scratchpad-wasmfs.mjs)  ─────▶ console.log/error
                              │
                              ├─ sqlite3InitModule()
                              │
                              ├─ sqlite3_wasmfs_opfs_dir()
                              │      └─ 永続ディレクトリパス取得
                              │
                              ├─ new oo.DB('/opfs/foo.db')
                              │
                              └─ test1()
                                     ├─ CREATE TABLE
                                     ├─ INSERT (timestamp)
                                     └─ SELECT COUNT(*)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scratchpad-wasmfs.html | `ext/wasm/scratchpad-wasmfs.html` | テンプレート | メイン画面HTML |
| scratchpad-wasmfs.mjs | `ext/wasm/scratchpad-wasmfs.mjs` | ソース | テスト実行Workerスクリプト |
| sqlite3-wasmfs.mjs | `ext/wasm/jswasm/sqlite3-wasmfs.mjs` | ソース | WASMFS対応sqlite3モジュール |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
